<%@ Page Language="C#" AutoEventWireup="true"  CodeFile="Repeater.aspx.cs" Inherits="_SelectMysql" %>
<%@ Import Namespace="System.Data" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>REPEATER with parent groups, sub groups and sums</title>
</head>
<body>
    <form id="form1" runat="server">
        <h1>REPEATER with parent groups, sub groups and sums</h1>
        This example shows how we can use a repeater to present data in parent groups, sub groups and calculate sums. 
        This example also shows how we can print a pdf document from this repeater control when
        the user clicks the button "Print report".<br />
        <br />
        Enter enddate:<asp:TextBox ID="txtEndDate" CssClass="textbox" runat="server"></asp:TextBox>
        <asp:Button ID="BtnSelectAssets" CausesValidation="true" ValidationGroup="PrintReport" CssClass="button" runat="server" Text="Create report" OnClick="BtnSelectAssets_Click" /><br />
        <asp:RequiredFieldValidator ID="EndDateRequired" runat="server" ControlToValidate="txtEndDate"
        Display="Dynamic" ErrorMessage="* Enddate must be entered" Width="216px" ValidationGroup="PrintReport">* Enddate must be entered</asp:RequiredFieldValidator>
        <asp:CompareValidator ID="DateCheck" runat="server" ControlToValidate="txtEndDate"
        Display="Dynamic" ErrorMessage="* Date must be entered as yyyy-mm-dd" Operator="DataTypeCheck" Type="Date" ValueToCompare="yyyy-MM-dd" EnableTheming="True" ValidationGroup="PrintReport" SetFocusOnError="True"></asp:CompareValidator>
        <br />
        
        <!-- start parent repeater -->
        <asp:repeater id="parentRepeater" runat="server">
        <HeaderTemplate>
        <table border="0" width="1024px" cellpadding="0" cellspacing="0" style="border: solid 1px silver">
                    <tr class="menu" style="height:20px">
                    <th>AssetID</th>
                    <th>Name</th>
                    <th>Purch. date</th>
                    <th style="text-align:right">Cost</th>
                    <th style="text-align:right">IB acc. depr.</th>
                    <th style="text-align:right">Year deprication</th>
                    <th style="text-align:right">Acc. depr.</th>
                    <th style="text-align:right">Book value</th>
                    </tr>
        </HeaderTemplate>
            <itemtemplate>
            <tr id="AccountRow" runat="server" visible='<%#!(DataBinder.Eval(Container.DataItem, "PPTotalt") == DBNull.Value)%>'>
            <td colspan="8" style="font-weight:bold"><asp:Label ID="AssetAccountLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetAccount")%>'></asp:Label>&nbsp;
            <asp:Label ID="AssetTypeNameLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "TypeName")%>'></asp:Label></td>
            </tr>
          <!-- start child repeater -->
          <asp:repeater id="childRepeater" datasource='<%#((DataRowView)Container.DataItem).Row.GetChildRows("assetsrelation")%>' runat="server">
                <itemtemplate>
                    <tr>
                        <td><asp:Literal ID="AssetOwnIDLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["AssetOwnID"]%>'></asp:Literal></td>
                        <td><asp:Literal ID="AssetNameLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["AssetName"]%>'></asp:Literal></td>
                        <td><asp:Literal ID="PurchaseDateLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["PurchaseDate"]%>'></asp:Literal></td>
                        <td style="text-align:right"><asp:Literal ID="PurchasePriceLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["PurchasePrice"]%>'></asp:Literal></td>
                        <td style="text-align:right"><asp:Literal ID="YearIBLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["YearIB"]%>'></asp:Literal></td>
                        <td style="text-align:right"><asp:Literal ID="YearDepLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["YearDep"]%>'></asp:Literal></td>
                        <td style="text-align:right"><asp:Literal ID="SumAckDepricationLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["SumAckDeprication"]%>'></asp:Literal></td>
                        <td style="text-align:right"><asp:Literal ID="AccountedValueLiteral" runat="server" Text='<%#((DataRowView)Container.DataItem)["AccountedValue"]%>'></asp:Literal></td>
                    </tr>
                </itemtemplate>
          </asp:repeater>
          <!-- end child repeater -->
                    <tr id="RowToHide" runat="server" visible='<%#!(DataBinder.Eval(Container.DataItem, "PPTotalt") == DBNull.Value)%>'>
                        <td style="font-weight:bold">Sum:</td>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td style="text-align:right; font-weight:bold"><asp:Literal ID="PPpriceLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "PPTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                        <td style="text-align:right; font-weight:bold"><asp:Literal ID="IBTotalLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "IBtotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                        <td style="text-align:right; font-weight:bold"><asp:Literal ID="YearDepLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "YearDepTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                        <td style="text-align:right; font-weight:bold"><asp:Literal ID="AckDepLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AckDepTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                        <td style="text-align:right; font-weight:bold"><asp:Literal ID="AccTotalLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AccValueTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                    </tr>
                    <tr id="EmptyRow" runat="server" visible='<%#!(DataBinder.Eval(Container.DataItem, "PPTotalt") == DBNull.Value)%>'>
                    <td colspan="8">&nbsp;</td>
                    </tr>
       </itemtemplate>                  
       <FooterTemplate>   
            </table>
       </FooterTemplate>
    </asp:repeater>
    <!-- end parent repeater -->
    <br />
    <h1>REPEATER that is used to insert or update data in a database table</h1>
    This exampel shows how we can present data in a repeater control and how to make it possible to use the repeater control
    to insert or update data in a database. We have added EnableViewState="false" for the textbox in the repeater so that it
    will be possible to edit the value in the textbox.<br />
    <br />
    Choose year to import from:
    <asp:DropDownList ID="YearDropDown" runat="server" CssClass="textbox" Font-Size="11px" Font-Names="Verdana" DataSourceID="SqlDataSource1" DataTextField="YearName" DataValueField="YearID">
    </asp:DropDownList>
    <asp:Button ID="ImportIB" CssClass="button" runat="server" Text="Import from EB" OnClick="ImportIB_Click" />
    <asp:SqlDataSource ID="SqlDataSource1" runat="server" ConnectionString="<%$ ConnectionStrings:ConnectionString %>" ProviderName="<%$ ConnectionStrings:ConnectionString.ProviderName %>"
        SelectCommand="SELECT YearID, CONCAT(CONVERT(StartDate, CHAR(10)), ' till ', CONVERT(EndDate, CHAR(10))) As YearName FROM AccountingYear WHERE ((CompanyID = @CompanyID) AND (YearID <> @YearID))">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenCompanyID" Name="CompanyID" PropertyName="Value" />
            <asp:ControlParameter ControlID="HiddenYearID" Name="YearID" PropertyName="Value" />
        </SelectParameters>
    </asp:SqlDataSource>
    <br />
    <br />
    <asp:Repeater ID="AddAckAvskrRepeater" runat="server">
    <HeaderTemplate>
            <table border="0" width="704px" cellpadding="1" cellspacing="0" style="border: solid 1px silver">
                <tr class="menu" style="height: 20px">
                <th id="Th1" runat="server" visible="false">AssetID</th>
                <th>Asset ID</th>
                <th>Name</th>
                <th style="text-align:right">OB Acc. deprication</th>
                </tr>
        </HeaderTemplate>

        <ItemTemplate>
                <tr>
                <td id="Td1" runat="server" visible="false"><asp:Literal ID="AssetIDLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetID")%>'></asp:Literal></td>
                <td><asp:Literal ID="AssetOwnIDLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetOwnID")%>'></asp:Literal></td>
                <td><asp:Literal ID="AssetNameLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetName")%>'></asp:Literal></td>
                <td style="text-align:right"><asp:Textbox ID="IBackAvskrivningar" EnableViewState="false" CssClass="textbox" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "UBValue")%>'></asp:Textbox></td>
                </tr>
        </ItemTemplate>

        <FooterTemplate>
            </table>
        </FooterTemplate>
    </asp:Repeater>
    <asp:Label ID="ErrorLabel" runat="server" ForeColor="Red"></asp:Label><br />
    <asp:Button ID="SaveIB" CssClass="button" runat="server" Text="Save OB for accumulated deprications" OnClick="SaveIB_Click" /><br />  
    <br />
        <asp:HiddenField ID="HiddenCompanyID" runat="server" />
        <asp:HiddenField ID="HiddenYearID" runat="server" />
        <asp:HiddenField ID="HiddenCompanyName" runat="server" />
    </form>
</body>
</html>
